/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.MessageUtils;

import gov.va.med.mhv.usermgmt.transfer.UserProfile;

/**
 * Defines message keys for user management
 * Note the difference between this class and 
 * {@link gov.va.med.mhv.usermgmt.messages.UserManagementMessages}
 * Where this class becomes part of the client jar, such that client code can 
 * refer to these constants, {@link gov.va.med.mhv.usermgmt.messages.
 * UserManagementMessages} does not.
 *  
 * The messages package should be incorporated in the client jar
 * which requires a change to an Atlas mda package. In that case the 
 * Atlas project must become part of the build process.
 * 
 * @author Rob Proper
 */
public final class MessageKeys {
	// Also note that this is a class and not an interface. This would be 
	// inappropriate use of an interface, and although it provides benefits, 
	// these benefits no longer apply in Java 5, as an entire class can be 
	// imported into a class, to the same effect as implementing the interface
	// However, it is more appropriate to prefix the class.
	
	/**
	 * Denotes that the primary contact has changed.
	 * Expects 2 inserts:
	 * <ol>
	 * 	<li start="0">The name of the old primary contact</li>
	 * 	<li>The name of the new primary contact</li>
	 * </ol>
	 */
	public static final String PRIMARY_CONTACT_CHANGED = 
		"user.contact.primary.changed";
	
	public static final String TOO_MANY_PRIMARY_CONTACTS = 
		"user.contact.tooManyPrimaryEmergencyContacts";
	
	public static final String CONTACT_CHANGED_SUCCESSFULLY = 
		"user.contact.changed.successfully";

    public static final String CONTACT_ADDED_SUCCESSFULLY = 
        "user.contact.added.successful";

    public static final String CONTACT_REMOVED_SUCCESSFULLY = 
        "user.contact.removed.successful";

    public static final String PRIMARY_CONTACT_REMOVED = 
        "user.contact.removed.primary";
    
    public static final String UNKNOWN_EXCEPTION_OCCURRED = 
        "unknown.exception.occurred";

    public static final String PATIENT_NOT_FOUND_AT_IPA = 
        "ipa.patient.not.found";
    
    public static final String MPI_ACCESS_PROBLEM_AT_IPA = 
        "ipa.patient.registry.access.error";

    public static final String ENSEMBLE_ACCESS_PROBLEM_AT_IPA = 
        "ipa.patient.registry.ensemble.access.error";

    public static final String DUPLICATE_PATIENT_ENTRY_AT_IPA = 
        "ipa.patient.duplicate.entries";

    public static final String CANNOT_UNAUTHENTICATE_PATIENT = 
        "ipa.patient.cannot.unauthenticate";

	//US8.16 & US7.16 - Last name is not blank and contains no numbers.
    public static final String LAST_NAME_NUMBERS = 
        "last.name.numbers";

    public static final String PATIENT_DOES_NOT_EXIST = 
        "patient.does.not.exist";

    public static final String PATIENT_IS_NOT_UNCORRELATED = 
        "patient.is.not.uncorrelated";

    public static final String PATIENT_IS_NOT_CORRELATED = 
        "patient.is.not.correlated";

    public static final String PATIENT_IS_NOT_PENDING_CORRELATION = 
        "patient.is.not.pending.correlation";

    public static final String PATIENT_IS_NOT_PENDING_UNCORRELATION = 
        "patient.is.not.pending.uncorrelation";
    
    public static final String PATIENT_IS_NOT_PENDING_AUTHENTICATION = 
        "patient.is.not.pending.authentication";
    
    public static final String PATIENT_IS_NOT_PENDING_UNAUTHENTICATION = 
        "patient.is.not.pending.unauthentication";

    public static final String PATIENT_IS_NOT_PENDING_SYNCHRONIZATION =
        "patient.is.not.pending.synchronization";

    public static final String PATIENT_MPI_CORRELATION_SUCCEEDED =
        "patient.mpi.correlation.succeeded";

    public static final String PATIENT_MPI_CORRELATION_FAILED =
        "patient.mpi.correlation.failed";

    public static final String PATIENT_MPI_UNCORRELATION_SUCCEEDED =
        "patient.mpi.uncorrelation.succeeded";

    public static final String PATIENT_MPI_UNCORRELATION_FAILED =
        "patient.mpi.uncorrelation.failed";

    public static final String PATIENT_MPI_REMOVAL_SUCCEEDED =
        "patient.mpi.removal.succeeded";

    public static final String PATIENT_CORRELATION_UPDATE_FAILED =
        "patient.correlation.update.failed";

    public static final String PATIENT_DUPLICATE_ENTRIES = 
        "patient.duplicate.entries";

    public static final String PATIENT_NOT_FOUND = "patient.not.found";

    public static final String USER_ALREADY_DEACTIVATED = 
        "user.already.deactivated";

    public static final String USER_ALREADY_ACTIVATED = 
        "user.already.activated";

	public static final String USER_NOT_A_PATIENT = "user.not.a.patient";

    public static final Message createUserAlreadyDeactivatedMessage(
        UserProfile userProfile)
    {
        final String[] properties = {};
        final Object[] inserts = { 
            (userProfile != null)? userProfile.getUserName() : "{unknown}"
        };
        return MessageUtils.createInformationalMessage(
            USER_ALREADY_DEACTIVATED, properties, inserts);
    }
    
    public static final Message createUserAlreadyActivatedMessage(
        UserProfile userProfile)
    {
        final String[] properties = {};
        final Object[] inserts = { 
            (userProfile != null)? userProfile.getUserName() : "{unknown}"
        };
        return MessageUtils.createInformationalMessage(
            USER_ALREADY_ACTIVATED, properties, inserts);
    }
    
	private MessageKeys() {
		// Class defines constant message keys. Should not be instantiated
	}

	
}
